# VAST LoFi-Prototypes

## About the project

As described in the [SESAR Air Traffic Management Master Plan](https://atmmasterplan.eu/), significant changes will impact the way European air traffic is handled in the future. While in 20 years, the amount of air traffic should have doubled and delays both on the ground and in the air should at the same time be reduced by 30%. Overall safety should also be improved. Instead of using standard airways, the implementation of 4D trajectories will ensure flights on a "practically unrestricted, optimum trajectory for as long as possible […] to meet very accurately an arrival time over a designated point" ([Source](https://www.skybrary.aero/index.php/4D_Trajectory_Concept)). To be able to handle these innovations, Air Traffic Control Officers (ATCOs) need appropriate tools, especially for the visualisation of 4D trajectories. 

Within the research project VAST, new concepts for visualising and sonifying complex air traffic scenes will be explored. In order to achieve the best possible results, the team follows the user-centred design process. To evaluate the created concepts with ATCOs as early as possible, the project team developed three low-fidelity prototypes: vast2D visualizes the air traffic in an enhanced two-dimensional way. vast2&3D combines a two- and three-dimensional representation of the air space. vastAbstract enhances the two-dimensional representation with an abstract visualisation of height and arrival time.

Facts about the project:
 * Project title: VAST - Virtual Airspace and Tower
 * Funding: Austrian Research Promotion Agency - FTI-Initiative Take Off
 * Duration: 01.09.2016 - 28.02.2019
 * Project ID: FFG 855215
 * Consortium: Fraunhofer Austria Research GmbH Graz (Project lead), Frequentis AG Vienna, St. Pölten University of Applied Sciences

## Getting Started

Double-click on VASTLo.exe. For more information, please read *Documentation_LoFi-Prototypes.pdf*.

## Development Team

The prototypes were developed by members of St. Pölten University of Applied Sciences: Markus Wagner, Christian Jandl, Michael Iber, Peter Judmaier, Gernot Rottermanner, Martin Kalteis, Perihan Rashed.

Contact: Peter Judmaier (peter.judmaier@fhstp.ac.at)
Website: http://mc.fhstp.ac.at/projects/vast

# License

Copyright 2018 FH St. Pölten

Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0.

Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.


